﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.DirectoryServices.AccountManagement;

namespace SWAT_Office_App
{
    public partial class Manage_User_Accounts_Form : Form
    {
        public Manage_User_Accounts_Form()
        {
            InitializeComponent();
            // Designate columns to include in listview for the Manage User Accounts Form
            ColumnHeader Column_1 = new ColumnHeader();
            Column_1.Text = "Username";
            Column_1.Width = 121;
            this.lst_UserAccounts.Columns.Add(Column_1);
            ColumnHeader Column_2 = new ColumnHeader();
            Column_2.Text = "Share";
            Column_2.Width = 46;
            Column_2.TextAlign = HorizontalAlignment.Center;
            this.lst_UserAccounts.Columns.Add(Column_2);
            ColumnHeader Column_3 = new ColumnHeader();
            Column_3.Text = "Size";
            Column_3.Width = 75;
            Column_3.TextAlign = HorizontalAlignment.Center;
            this.lst_UserAccounts.Columns.Add(Column_3);
            ColumnHeader Column_4 = new ColumnHeader();
            Column_4.Text = "Date Created";
            Column_4.Width = 80;
            Column_4.TextAlign = HorizontalAlignment.Center;
            this.lst_UserAccounts.Columns.Add(Column_4);

            PaintUserListbox();
            this.btn_Delete.Enabled = false;
            this.btn_Pass.Enabled = false;
            this.btn_Share.Enabled = false;
            this.btn_OpenShare.Enabled = false;
            
            this.lst_UserAccounts.ItemSelectionChanged += new ListViewItemSelectionChangedEventHandler(this.lst_ItemSelectionChanged);
            this.Activated += new EventHandler(this.form_Activated);
        }
        private void PaintUserListbox()
        {
            try
            {
                // Function for refreshing/painting the listbox
                this.lst_UserAccounts.BeginUpdate();
                Manage_User_Accounts.QueryUserAccounts();

                // Temporary entries in listview
                //ListViewItem entry;
                //ListViewItem.ListViewSubItem s_entry;
                //entry = new ListViewItem();
                //entry.Text = "TestUser";
                //s_entry = new ListViewItem.ListViewSubItem();
                //s_entry.Text = "Yes";
                //entry.SubItems.Add(s_entry);
                //s_entry = new ListViewItem.ListViewSubItem();
                //s_entry.Text = "Yes";
                //entry.SubItems.Add(s_entry);
                //s_entry = new ListViewItem.ListViewSubItem();
                //s_entry.Text = "01/05/2010";
                //entry.SubItems.Add(s_entry);
                //this.lst_User_Accounts.Items.Add(entry);

                this.lst_UserAccounts.Items.Clear();
                // Prevents system accounts from showing, depending on settings
                foreach (UserPrincipal user in Manage_User_Accounts.UserAccountsList)
                {
                    ListViewItem entry = new ListViewItem();
                    bool remove = false;
                    foreach (string hiddenUser in Settings_Form.hiddenAccounts)
                    {
                        if (user.Name.ToLower() == hiddenUser.ToLower())
                        {
                            remove = true;
                            break;
                        }
                    }
                    // Populates the subitem columns for each entry
                    if (remove == false)
                    {
                        ListViewItem.ListViewSubItem s_share = new ListViewItem.ListViewSubItem();
                        if (Manage_User_Accounts.QueryUserSharedFolderExist(user.Name))
                            s_share.Text = "Yes";
                        else
                            s_share.Text = "No";
                        entry.SubItems.Add(s_share);
                        ListViewItem.ListViewSubItem s_size = new ListViewItem.ListViewSubItem();
                        long size = Manage_User_Accounts.GetShareSize(user.Name);
                        if ((size / 1073741824) > 0)
                            s_size.Text = (size / 1073741824).ToString() + " GB";
                        else
                            s_size.Text = (size / 1048576).ToString() + " MB";
                        entry.SubItems.Add(s_size);
                        ListViewItem.ListViewSubItem s_datecreated = new ListViewItem.ListViewSubItem();
                        s_datecreated.Text = user.Description;
                        entry.SubItems.Add(s_datecreated);
                    }
                    if (remove == false)
                    {
                        entry.Text = user.Name;
                        this.lst_UserAccounts.Items.Add(entry);
                    }
                }
                this.lst_UserAccounts.EndUpdate();
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        private void lst_ItemSelectionChanged(object sender, ListViewItemSelectionChangedEventArgs e)
        {
            lst_ValidateAll();
        }
        private void lst_ValidateAll()
        {
            // Enables/disables certain buttons depending on number of items selected
            ListView.SelectedListViewItemCollection collection = this.lst_UserAccounts.SelectedItems;
            
            if (collection.Count == 0)
            {
                this.btn_Delete.Enabled = false;
                this.btn_Pass.Enabled = false;
                this.btn_Share.Enabled = false;
                this.btn_OpenShare.Enabled = false;
            }
            else if (collection.Count == 1)
            {
                // Checks if any of the selected items are system accounts
                bool check = false;
                foreach (string systemUser in Settings_Form.systemAccounts)
                {
                    if (collection[0].Text.ToLower() == systemUser.ToLower())
                        check = true;
                }
                if (check == false)
                {
                    this.btn_Delete.Enabled = true;
                    this.btn_Pass.Enabled = true;
                    this.btn_Share.Enabled = true;
                    ListViewItem.ListViewSubItem subItem = collection[0].SubItems[1];
                    if (subItem.Text == "Yes")
                        this.btn_OpenShare.Enabled = true;
                    else
                        this.btn_OpenShare.Enabled = false;
                }
                else
                {
                    this.btn_Delete.Enabled = false;
                    this.btn_Pass.Enabled = false;
                    this.btn_Share.Enabled = false;
                    this.btn_OpenShare.Enabled = false;
                }
            }
            else
            {
                this.btn_Delete.Enabled = true;
                this.btn_Pass.Enabled = false;
                this.btn_Share.Enabled = false;
                this.btn_OpenShare.Enabled = false;
            }
        }
        private void form_Activated(object sender, EventArgs e)
        {
            // Refreshes form on form activation
            Manage_User_Accounts.QueryUserAccounts();
            PaintUserListbox();
        }
        private void btn_Exit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        private void btn_Refresh_Click(object sender, EventArgs e)
        {
            PaintUserListbox();
        }
        private void btn_Add_Click(object sender, EventArgs e)
        {
            Add_User_Account_Form.Add_User_Account_Instance.ShowDialog();
            lst_ValidateAll();
        }
        private void btn_Delete_Click(object sender, EventArgs e)
        {
            if (!Manage_User_Accounts.SessionsOpen())
            {
                ListView.SelectedListViewItemCollection selectedItems = this.lst_UserAccounts.SelectedItems;
                List<string> userList = new List<string>();
                foreach (ListViewItem user in selectedItems)
                    userList.Add(user.Text);
                Delete_User_Verify_Form newForm = new Delete_User_Verify_Form(userList);
                newForm.ShowDialog();
            }
            else
                MessageBox.Show("Sessions are still open. Please close them before deleting accounts", "Error");
            PaintUserListbox();
            lst_ValidateAll();
        }
        private void btn_Pass_Click(object sender, EventArgs e)
        {
            ListView.SelectedListViewItemCollection selectedItems = this.lst_UserAccounts.SelectedItems;
            Reset_User_Password_Form newForm = new Reset_User_Password_Form(selectedItems[0].Text);
            newForm.ShowDialog();

            PaintUserListbox();
            lst_ValidateAll();
        }
        private void btn_Share_Click(object sender, EventArgs e)
        {
            ListView.SelectedListViewItemCollection selectedItems = this.lst_UserAccounts.SelectedItems;
            Toggle_User_Verify_Form newForm = new Toggle_User_Verify_Form(selectedItems[0].Text);
            newForm.ShowDialog();

            PaintUserListbox();
            lst_ValidateAll();
        }
        private void btn_OpenShare_Click(object sender, EventArgs e)
        {
            ListView.SelectedListViewItemCollection selectedItems = this.lst_UserAccounts.SelectedItems;
            string openFolderString = Settings_Form.sharedFolderLocation + "\\" + selectedItems[0].Text;
            System.Diagnostics.Process proc = new System.Diagnostics.Process();
            proc.StartInfo.FileName = openFolderString;
            proc.Start();
        }
    }
}
